uniform mat4 v_mvpMatrix;

attribute vec3 v_position;
attribute vec2 v_maskTextureCoord;
attribute vec2 v_colorTextureCoord;
attribute vec2 v_textureCoord1;
attribute vec2 v_textureCoord2;
attribute vec2 v_textureCoord3;
attribute vec4 v_color;

uniform float scroll_time1;
uniform float scroll_time2;
uniform float scroll_time3;

varying vec2 p_maskTextureCoord;
varying vec2 p_colorTextureCoord;
varying vec2 p_textureCoord1;
varying vec2 p_textureCoord2;
varying vec2 p_textureCoord3;
varying vec4 p_color;

void main()
{
    vec4 real_position;
    real_position.xyz = v_position;
    real_position.a = 1.0;
    
    gl_Position = v_mvpMatrix * real_position;
    p_maskTextureCoord = v_maskTextureCoord;
    p_colorTextureCoord = v_colorTextureCoord;
    p_textureCoord1 = v_textureCoord1 - vec2(0, scroll_time1);
    p_textureCoord2 = v_textureCoord2 - vec2(0, scroll_time2);
    p_textureCoord3 = v_textureCoord3 - vec2(0, scroll_time3);
 
    p_color = v_color;
}

